package com.ejie.ab04b.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.EstudioDocAperturasDao;
import com.ejie.ab04b.model.EstudioDocAperturas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0464s00ServiceImpl generated by UDA, 14-Feb-2017 10:29:39.
 * 
 * @author UDA
 */

@Service(value = "estudioDocAperturasServiceImpl")
public class EstudioDocAperturasServiceImpl
		implements EstudioDocAperturasService {

	@Autowired()
	private EstudioDocAperturasDao ab0464s00Dao;

	/**
	 * Inserts a single row in the Ab0464s00 table.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *  Ab0464s00
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocAperturas add(EstudioDocAperturas ab0464s00) {
		return this.ab0464s00Dao.add(ab0464s00);
	}

	/**
	 * Updates a single row in the Ab0464s00 table.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *  Ab0464s00
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	@Transactional(rollbackFor = Throwable.class)
	public EstudioDocAperturas update(EstudioDocAperturas ab0464s00) {
		return this.ab0464s00Dao.update(ab0464s00);
	}

	/**
	 * Finds a single row in the Ab0464s00 table.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *  Ab0464s00
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 * @return the estudio doc aperturas
	 */
	public EstudioDocAperturas find(EstudioDocAperturas ab0464s00) {
		return (EstudioDocAperturas) this.ab0464s00Dao.find(ab0464s00);
	}

	/**
	 * Deletes a single row in the Ab0464s00 table.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 */
	@Transactional(rollbackFor = Throwable.class)
	public void remove(EstudioDocAperturas ab0464s00) {
		this.ab0464s00Dao.remove(ab0464s00);
	}

	/**
	 * Finds a list of rows in the Ab0464s00 table.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0464s00>
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	public List<EstudioDocAperturas> findAll(EstudioDocAperturas ab0464s00,
			JQGridRequestDto jqGridRequestDto) {
		return (List<EstudioDocAperturas>) this.ab0464s00Dao.findAll(ab0464s00,
				jqGridRequestDto);
	}

	/**
	 * Finds rows in the Ab0464s00 table using like.
	 * 
	 *  ab0464s00
	 *            Ab0464s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0464s00>
	 *
	 * @param ab0464s00 the ab 0464 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<EstudioDocAperturas> findAllLike(EstudioDocAperturas ab0464s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return (List<EstudioDocAperturas>) this.ab0464s00Dao
				.findAllLike(ab0464s00, jqGridRequestDto, startsWith);
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0464s00 table.
	 * 
	 *  filterAb0464s00
	 *            Ab0464s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  JQGridResponseDto<Ab0464s00>
	 *
	 * @param filterAb0464s00 the filter ab 0464 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the JQ grid response dto
	 */
	public JQGridResponseDto<EstudioDocAperturas> filter(
			EstudioDocAperturas filterAb0464s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		List<EstudioDocAperturas> listaAb0464s00 = this.ab0464s00Dao
				.findAllLike(filterAb0464s00, jqGridRequestDto, false);
		Long recordNum = this.ab0464s00Dao
				.findAllLikeCount(filterAb0464s00 != null ? filterAb0464s00
						: new EstudioDocAperturas(), false);
		if (jqGridRequestDto.getMultiselection().getSelectedIds() != null) {
			List<TableRowDto<EstudioDocAperturas>> reorderSelection = this.ab0464s00Dao
					.reorderSelection(filterAb0464s00, jqGridRequestDto,
							startsWith);
			return new JQGridResponseDto<EstudioDocAperturas>(jqGridRequestDto,
					recordNum, listaAb0464s00, reorderSelection);
		}
		return new JQGridResponseDto<EstudioDocAperturas>(jqGridRequestDto,
				recordNum, listaAb0464s00);
	}

	/**
	 * Searches rows in the Ab0464s00 table.
	 * 
	 *  filterAb0464s00
	 *            Ab0464s00
	 *  searchAb0464s00
	 *            Ab0464s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Ab0464s00>>
	 *
	 * @param filterAb0464s00 the filter ab 0464 s 00
	 * @param searchAb0464s00 the search ab 0464 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	public List<TableRowDto<EstudioDocAperturas>> search(
			EstudioDocAperturas filterAb0464s00,
			EstudioDocAperturas searchAb0464s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0464s00Dao.search(filterAb0464s00, searchAb0464s00,
				jqGridRequestDto, startsWith);
	}

	/**
	 * Reorder the selection made in Ab0464s00 table.
	 * 
	 *  filterAb0464s00
	 *            Ab0464s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  Object
	 *
	 * @param filterAb0464s00 the filter ab 0464 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the object
	 */
	public Object reorderSelection(EstudioDocAperturas filterAb0464s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		return this.ab0464s00Dao.reorderSelection(filterAb0464s00,
				jqGridRequestDto, startsWith);
	}

}
